package simulator.plus;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import service.ComposedTransition;
import service.ComposedState;
import service.ServiceFactory;
import service.SimpleTransition;
import service.SimpleState;
import service.State;
import service.TransitionSystem;
import simulator.Simulation;

/**
 * 
 * @author rarefatto
 *
 */
public class SimulationPlusImpl extends Simulation {

	
	
	
	
	
	
	
	
	
	
	/*---------------------------INSTANCE VARIABLES-------------------------*/
	
	
	/**
	 * variable that stores the Target service transition system.
	 */
	private TransitionSystem<SimpleState, SimpleTransition> target;
	/**
	 * Stores the transition system derived by the simulation over the asynchronous product
	 */
	private TransitionSystem<ComposedState, ComposedTransition> composition;
	private TransitionSystem<ComposedState, ComposedTransition> asyncProd;
	/**
	 * Stores the relations between target states and composed states (represents the real simulation relation)
	 */
	private HashSet<SimilarState> relation; 
	
	
	
	
	
	
	/*----------------------------METHODS-----------------------------*/
	
	
	/*TODO CHECK IF IT'S NECESSARY
	/**
	 * Constructor, not usable from outside the class; use generate() instead;
	 * @param target the target service transition system
	 * @param composition the composed transition system
	 */
	/*private SimulationImpl(TransitionSystem<SimpleState, SimpleAction> target,
	          TransitionSystem<ComposedState, ComposedAction> composition){
		this.target=target;
		this.composition=composition;
	}*/
	
	private SimulationPlusImpl(){}
	
	@Override
	/**
	 * Returns the transition system deriving by the simulation
	 */
	public TransitionSystem<ComposedState, ComposedTransition> getCompositionTs() {
		return composition;
	}


	@Override
	/**
	 * Returns the target Transition System
	 */
	public TransitionSystem<SimpleState, SimpleTransition> getTargetTs() {
		return target;
	}
	
	
	/**
	 * Generates the simulation of the target service with all the available services
	 * @param target the target service transition system
	 * @param availableServices the available services for the simulation
	 * @return a simulation of the target service
	 * @throws Exception if it's not possibile to simulate the service
	 */
	public static SimulationPlusImpl generate(	TransitionSystem<SimpleState, SimpleTransition> target,
										TransitionSystem<SimpleState, SimpleTransition>[] availableServices,
										ServiceFactory serviceFactory)
										throws Exception{
		
		
		//get the async-product result as a transition system
		//that is composed by the pruned async product and the couples candidate for the simulation
		ResultPrunedAsyncProduct resultAsyncPrunedProd=asynchronousProductPruned(target,availableServices,serviceFactory);
		HashSet<SimilarState> r=resultAsyncPrunedProd.getCandidatesForSimulation();
		TransitionSystem<ComposedState, ComposedTransition> asyncPrunedProd=resultAsyncPrunedProd.getPrunedAsyncProd();
		//while r was modified in the last iteration
		boolean rModified=true;
		while(!r.isEmpty() && rModified==true){
			//this set contain couples that will be removed at the end of the iteration
			HashSet<SimilarState> coupleToRemove=new HashSet<SimilarState>();
			rModified=false;
			//iterator over the elemen of t
			Iterator<SimilarState> itCurrentSimilarCouple=r.iterator();
			while(itCurrentSimilarCouple.hasNext()){
				//currentSimilarCouple is the current couple of state that will be checked
				SimilarState currentSimilarCouple = itCurrentSimilarCouple.next();
				Iterator<SimpleTransition> itTargetActions=target.getActionsOf(
																			currentSimilarCouple.getTargetState()
																			).iterator();
				boolean existSimulation=true;
				//check if the available state can be execute every action that can be
				//executed by the target service
				while(itTargetActions.hasNext() && existSimulation==true){
					existSimulation=false;
					SimpleTransition currentTargetAction=itTargetActions.next();
					
					Iterator<ComposedTransition> itActionsOfComposedState=asyncPrunedProd.getActionsOfStateWithName(
																		currentSimilarCouple.getAvalableServiceState(),
																		currentTargetAction.getName()
																		).iterator();
					while(itActionsOfComposedState.hasNext()){

						ComposedTransition currentActionComposedState=itActionsOfComposedState.next();
						SimilarState temp=new SimilarState((SimpleState)currentTargetAction.getStateTo(),
															   currentActionComposedState.getStateTo()
															);
						if(r.contains(temp))
							existSimulation=true;
							
					}						
				}
				//if the couple isn't in the simulation, add the couple in the set of couples that will be removed
				if(!existSimulation){
					coupleToRemove.add(currentSimilarCouple);
				}
			}
			if(coupleToRemove.size()>0){
				rModified=true;
			}
		}
		//create the composition TS
		//contains only the states(of the available service)that are in the set r
		TransitionSystem<ComposedState, ComposedTransition> resultPrunedWithSimulation=
			                                            	serviceFactory.createComposedTransitionSystem();
		Iterator<SimilarState> itR=r.iterator();
		while(itR.hasNext()){
			ComposedState currentState=itR.next().getAvalableServiceState();
			try{
				resultPrunedWithSimulation.addState(currentState);
			}catch (Exception e) {
			}
		}
		//for each state, add a transition only if the target service does it
		Iterator<SimilarState> itSimulationData=r.iterator();
		while(itSimulationData.hasNext()){
			SimilarState simulationCouple=itSimulationData.next();
			
			SimpleState currentSimpleState=simulationCouple.getTargetState();
			Iterator<SimpleTransition> itSimpleAction =target.getActionsOf(currentSimpleState).iterator();
			while(itSimpleAction.hasNext()){
				SimpleTransition currentSimpleAction=itSimpleAction.next();
				ComposedState composedState=simulationCouple.getAvalableServiceState();
				Iterator<ComposedTransition> itComposedAction =resultAsyncPrunedProd.getPrunedAsyncProd().getActionsOfStateWithName(composedState,currentSimpleAction.getName()).iterator();			
				while(itComposedAction.hasNext()){
					ComposedTransition currentComposedAction=itComposedAction.next();
						SimilarState candidatesForSimulation=new SimilarState((SimpleState)currentSimpleAction.getStateTo(),
                                currentComposedAction.getStateTo());
						if(r.contains(candidatesForSimulation)){
							Set<ComposedTransition> composedActionOther=getActionsOfStateWithNameAndTSandStateFrom(resultAsyncPrunedProd.getPrunedAsyncProd(), currentComposedAction);
							if(composedActionOther.size()==1)
								resultPrunedWithSimulation.addAction(currentComposedAction.getStateFrom(),currentComposedAction.getStateTo(),currentComposedAction);
							else {
								boolean toAdd=true;
								Iterator<ComposedTransition> itOtherComposedAction=composedActionOther.iterator();
								while(itOtherComposedAction.hasNext()){
									ComposedTransition otherComposedAction=itOtherComposedAction.next();
									SimilarState otherCandidateForSimulation=new SimilarState((SimpleState)currentSimpleAction.getStateTo(),
			                                otherComposedAction.getStateTo());
									if(!r.contains(otherCandidateForSimulation)){
										toAdd=false;
									}
								}
								if(toAdd){
									resultPrunedWithSimulation.addAction(currentComposedAction.getStateFrom(),currentComposedAction.getStateTo(),currentComposedAction);									
								}
							}
						}
				}
			}
			
		}
		
		SimulationPlusImpl result=new SimulationPlusImpl();
		result.target=target;
		result.composition=resultPrunedWithSimulation;
		result.asyncProd=resultAsyncPrunedProd.getPrunedAsyncProd();
		result.relation=r;
		return  result;
	}

	private static Set<ComposedTransition> getActionsOfStateWithNameAndTSandStateFrom(TransitionSystem<ComposedState,ComposedTransition> ts,ComposedTransition action) throws Exception{
		Set<ComposedTransition> partialResult=ts.getActionsOfStateWithName(action.getStateFrom(), action.getName());
		Iterator<ComposedTransition> it=partialResult.iterator();
		Set<ComposedTransition> result=new HashSet<ComposedTransition>();
		while(it.hasNext()){
			ComposedTransition currentAction=it.next();
			if(action.getService().getName().equals(currentAction.getService().getName()))
				result.add(currentAction);
		}
		return result;
	}
	
	/**
	 * Method that computes the asynchronous product between the given transition systems
	 * @param availableServices an array that contains the transition systems
	 * @return a composed transition system that represents the asynchronous product
	 * @throws Exception Error in the cartesian product have occurred
	 */
	public static ResultPrunedAsyncProduct asynchronousProductPruned(
											TransitionSystem<SimpleState, SimpleTransition> target,
											TransitionSystem<SimpleState, SimpleTransition>[] availableServices,
											ServiceFactory serviceFactory
											) throws Exception {
		//set the initialState of all the services
		SimpleState initialStates[]=new SimpleState[availableServices.length];
		for(int i=0;i<availableServices.length;i++){
			initialStates[i]=availableServices[i].getInitial();
		}
		ComposedState initialState=serviceFactory.createComposedState(initialStates);
		SimpleState initialStateTarget=target.getInitial();
		//create setStateNotExpanded that contain all the state that will be examined
		HashSet<SimilarState> setStateNotExpanded=new HashSet<SimilarState>();
		//create setStateExpanded that contain all the state was already checked
		HashSet<SimilarState> setStateExpanded=new HashSet<SimilarState>();
		HashSet<ComposedTransition> setStateExpandedAction=new HashSet<ComposedTransition>();
		setStateNotExpanded.add(new SimilarState(initialStateTarget,initialState));
		//while there are state not expanded
		while(!setStateNotExpanded.isEmpty()){
			SimilarState currentSimilar=setStateNotExpanded.iterator().next();

			setStateNotExpanded.remove(currentSimilar);
			//check if the target state is final and the ComposedState isn't final, in this case remove it
			if(currentSimilar.getTargetState().isFinal() && !currentSimilar.getAvalableServiceState().isFinal())
				continue;
			//check if the current ComposedState can execute all the action that can be executed by the target
			boolean allActionSimulated=true;
			if(setStateExpanded.contains(currentSimilar))
				continue;
			setStateExpanded.add(currentSimilar);

			HashSet<SimilarState> candidatesForSimilar=new HashSet<SimilarState>();
			HashSet<ComposedTransition> candidatesForSimilarActions=new HashSet<ComposedTransition>();
			
			SimpleState currentTargetState=currentSimilar.getTargetState();
			ComposedState currentComposedState=currentSimilar.getAvalableServiceState();
			Iterator<SimpleTransition> itTargetStateAction=target.getActionsOf(currentTargetState).iterator();
			while(itTargetStateAction.hasNext() && allActionSimulated==true){
				boolean thisActionSimulated=false;
				SimpleTransition currentTargetAction=itTargetStateAction.next();
				for(int i=0;i<currentComposedState.getStates().length && allActionSimulated==true;i++){
					Iterator<SimpleTransition> itActionsOfThisComposedState=
						availableServices[i].getActionsOf(
												(SimpleState)currentComposedState.getServicesState(i)
												).iterator();
					while(itActionsOfThisComposedState.hasNext()){
						SimpleTransition currentAction=itActionsOfThisComposedState.next();
						if(currentAction.getName().equals(currentTargetAction.getName())){
							//add this couple to the pruned asyncronous product
							State[] newStates=currentComposedState.getStates().clone();
							newStates[i]=currentAction.getStateTo();
							SimpleState nextTargetState=(SimpleState)currentTargetAction.getStateTo();
							ComposedState nextComposedState=serviceFactory.createComposedState(newStates);
							SimilarState newCandidate=new SimilarState(nextTargetState,nextComposedState);
							candidatesForSimilar.add(newCandidate);
							ComposedTransition candidateAction=serviceFactory.createComposedAction(
																			  currentTargetAction.getName(),
																			  availableServices[i],
																			  currentComposedState,
																			  nextComposedState
																			  );
							candidatesForSimilarActions.add(candidateAction);
							thisActionSimulated=true;
						}
							
					}
				}
				if(!thisActionSimulated){
					allActionSimulated=false;
				}
			}
			if(allActionSimulated){
				Iterator<SimilarState> itCandidateSimilar=candidatesForSimilar.iterator();
				while(itCandidateSimilar.hasNext()){
					SimilarState currentSimilarState=itCandidateSimilar.next();
					if(!setStateExpanded.contains(currentSimilarState)){
						setStateNotExpanded.add(currentSimilarState);

					}
				}
				Iterator<ComposedTransition> itCandidateSimilarAction=candidatesForSimilarActions.iterator();
				while(itCandidateSimilarAction.hasNext()){
					ComposedTransition currentCandidateSimilarAction=itCandidateSimilarAction.next();
					setStateExpandedAction.add(currentCandidateSimilarAction);					
				}
			}
		}
		TransitionSystem<ComposedState,ComposedTransition> result=serviceFactory.createComposedTransitionSystem();
		Iterator<SimilarState> itSimilarState=setStateExpanded.iterator();
		while(itSimilarState.hasNext()){
			try{
			result.addState(itSimilarState.next().getAvalableServiceState());
			}catch(Exception e){
				
			}
		}
		Iterator<ComposedTransition> itAction=setStateExpandedAction.iterator();
		while(itAction.hasNext()){
			ComposedTransition currentAction=itAction.next();
			result.addAction(currentAction.getStateFrom(), currentAction.getStateTo(), currentAction);
		}

		return new ResultPrunedAsyncProduct(result,setStateExpanded);
	
	}
		

		
	
	
		

	public Set<State[]> getAllSimilarState() {
		Set<State[]> result=new HashSet<State[]>();
		if(relation==null){
			return null;
		}
		else{
			Iterator<SimilarState> it=relation.iterator();
			while(it.hasNext()){
				SimilarState currentSimilarState=it.next();
				result.add(new State[]{
						currentSimilarState.getTargetState(),
						currentSimilarState.getAvalableServiceState()
					});
			}
			return result;	
		}
	}

	/* (non-Javadoc)
	 * @see simulator.Simulation#getSimilarStates(service.State)
	 */
	@Override
	public Set<ComposedState> getSimilarStates(State targetState) {
		Set<ComposedState> result=new HashSet<ComposedState>();
		Iterator<SimilarState> it=relation.iterator();
		while(it.hasNext()){
			SimilarState currentSimilarState=it.next();
			if(currentSimilarState.getTargetState().getName().equals(targetState.getName()))
				result.add(currentSimilarState.getAvalableServiceState());
		}
		return result;
	}


	/* (non-Javadoc)
	 * @see simulator.Simulation#getAsyncProduct()
	 */
	@Override
	public TransitionSystem<ComposedState, ComposedTransition> getAsyncProduct() {
		return asyncProd;
	}

	public Set<SimilarState> getAllSimilarState1() {
		if(relation==null){
			return null;
		}
		else
			return new HashSet<SimilarState>(relation);
	}
}
